/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.item.sigil;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wayoftime.bloodmagic.altar.IBloodAltar;
import wayoftime.bloodmagic.api.compat.IAltarReader;
import wayoftime.bloodmagic.client.hud.GuiEditHUD;
import wayoftime.bloodmagic.common.item.sigil.ISigil;
import wayoftime.bloodmagic.common.item.sigil.ItemSigilBase;
import wayoftime.bloodmagic.common.tile.TileIncenseAltar;
import wayoftime.bloodmagic.core.data.Binding;
import wayoftime.bloodmagic.util.ChatUtil;
import wayoftime.bloodmagic.util.helper.NetworkHelper;
import wayoftime.bloodmagic.util.helper.NumeralHelper;
import wayoftime.bloodmagic.util.helper.PlayerHelper;

public class ItemSigilDivination
extends ItemSigilBase
implements IAltarReader {
    private final boolean isSimple;

    public ItemSigilDivination(boolean simple) {
        super(simple ? "divination" : "seer");
        this.isSimple = simple;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof ISigil.Holding) {
            stack = ((ISigil.Holding)stack.m_41720_()).getHeldItem(stack, player);
        }
        if (PlayerHelper.isFakePlayer(player)) {
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!world.f_46443_) {
            if (player.m_6144_()) {
                return InteractionResultHolder.m_19096_((Object)stack);
            }
            BlockHitResult position = Item.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
            if (position == null || position.m_6662_() == HitResult.Type.MISS) {
                super.m_7203_(world, player, hand);
                Binding binding = this.getBinding(stack);
                if (binding != null) {
                    int currentEssence = NetworkHelper.getSoulNetwork(binding).getCurrentEssence();
                    ArrayList toSend = Lists.newArrayList();
                    if (!binding.getOwnerId().equals(player.m_36316_().getId())) {
                        toSend.add(new TranslatableComponent(this.tooltipBase + "otherNetwork", new Object[]{binding.getOwnerName()}));
                    }
                    toSend.add(new TranslatableComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}));
                    ChatUtil.sendNoSpam(player, toSend.toArray(new Component[toSend.size()]));
                }
            } else if (position.m_6662_() == HitResult.Type.BLOCK) {
                BlockEntity tile = world.m_7702_(new BlockPos(position.m_82450_()));
                if (tile != null && tile instanceof IBloodAltar) {
                    IBloodAltar altar = (IBloodAltar)tile;
                    int tier = altar.getTier();
                    int currentEssence = altar.getCurrentBlood();
                    int capacity = altar.getCapacity();
                    altar.checkTier();
                    if (this.isSimple) {
                        ChatUtil.sendNoSpam(player, new Component[]{new TranslatableComponent(this.tooltipBase + "currentAltarTier", new Object[]{NumeralHelper.toRoman(tier)}), new TranslatableComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}), new TranslatableComponent(this.tooltipBase + "currentAltarCapacity", new Object[]{capacity})});
                    } else {
                        ChatUtil.sendNoSpam(player, new Component[]{new TranslatableComponent(this.tooltipBase + "currentAltarTier", new Object[]{NumeralHelper.toRoman(tier)}), new TranslatableComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}), new TranslatableComponent(this.tooltipBase + "currentAltarCapacity", new Object[]{capacity})});
                    }
                } else if (tile != null && tile instanceof TileIncenseAltar) {
                    TileIncenseAltar altar = (TileIncenseAltar)tile;
                    altar.recheckConstruction();
                    double tranquility = altar.tranquility;
                    ChatUtil.sendNoSpam(player, new Component[]{new TranslatableComponent(this.tooltipBase + "currentTranquility", new Object[]{(int)(100.0 * (double)((int)(100.0 * tranquility)) / 100.0)}), new TranslatableComponent(this.tooltipBase + "currentBonus", new Object[]{(int)(100.0 * altar.incenseAddition)})});
                } else {
                    Binding binding = this.getBinding(stack);
                    if (binding != null) {
                        int currentEssence = NetworkHelper.getSoulNetwork(binding).getCurrentEssence();
                        ArrayList toSend = Lists.newArrayList();
                        if (!binding.getOwnerId().equals(player.m_36316_().getId())) {
                            toSend.add(new TranslatableComponent(this.tooltipBase + "otherNetwork", new Object[]{binding.getOwnerName()}));
                        }
                        toSend.add(new TranslatableComponent(this.tooltipBase + "currentEssence", new Object[]{currentEssence}));
                        ChatUtil.sendNoSpam(player, toSend.toArray(new Component[toSend.size()]));
                    }
                }
            }
        } else if (player.m_6144_()) {
            this.openEditHUDScreen();
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void openEditHUDScreen() {
        Minecraft.m_91087_().m_91152_((Screen)new GuiEditHUD(null));
    }
}

